//Digital Simulation of P, PI, PD, and PID controllers
// 1- Open Loop Program 
num=poly([10],'s','coeff');//Numerator input
den=poly([20 10 1],'s','coeff');//Denominator input
q=syslin('c',num/den)//Ratio of the numerator to the denominator
t=0:0.05:2.5;//time interval
p=csim('step',t,q);
subplot(321)
plot2d(t,p);
xtitle(['Open Loop '],'Time(Second)', 'Amplitude' );

// 2- P Control Program
kp=300;
num=poly([kp],'s','coeff');
den=poly([20+kp 10 1],'s','coeff');
q=syslin('c',num/den)
t=0:0.01:2;
p=csim('step',t,q);
subplot(322)
plot2d(t,p);
xtitle(['P Control '],'Time(Second)', 'Amplitude' );

// 3 – PI Control Program
kp=30;
ki=70;
num=poly([ki kp],'s','coeff');
den=poly([ki 20+kp 10 1],'s','coeff');
q=syslin('c',num/den)
t=0:0.01:2;
p=csim('step',t,q);
subplot(323)
plot2d(t,p); 
xtitle(['PI Control '],'Time(Second)', 'Amplitude' );

// 4 – PD Control Program
kp=300;
kd=10;
num=poly([kp kd],'s','coeff');
den=poly([20+kp 10+kd 1],'s','coeff');
q=syslin('c',num/den)
t=0:0.01:2;
p=csim('step',t,q);
subplot(324)
plot2d(t,p);
xtitle(['PD Control '],'Time(Second)', 'Amplitude' );

// 5 – PID Control Program
kp=350;
kd=50;
ki=300;
num=poly([ki kp kd],'s','coeff');
den=poly([ki 20+kp 10+kd 1],'s','coeff');
q=syslin('c',num/den)
t=0:0.01:2;
p=csim('step',t,q);
subplot(325)
plot2d(t,p);
xtitle(['PID Control '],'Time(Second)', 'Amplitude' );

